<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\Facebook\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_facebook_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_facebook_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_facebook_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['facebook'] = array(
        'title' => __( 'Facebook', 'automatorwp-pro' ),
        'icon' => 'dashicons-facebook-alt',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_facebook_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_facebook_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_facebook_';

    $meta_boxes['automatorwp-facebook-settings'] = array(
        'title' => automatorwp_dashicon( 'facebook-alt' ) . __( 'Facebook', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_facebook_settings_fields', array(
            $prefix . 'application_id' => array(
                'name' => __( 'Application ID:', 'automatorwp-pro' ),
                'desc' => __( 'Your Facebook Application ID.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'application_secret' => array(
                'name' => __( 'Application Secret:', 'automatorwp-pro' ),
                'desc' => __( 'Your Facebook Application secret.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'redirect_url' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_facebook_redirect_url_display_cb',
            ),
            $prefix . 'authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_facebook_authorize_display_cb',
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_facebook_meta_boxes", 'automatorwp_facebook_settings_meta_boxes' );

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_facebook_redirect_url_display_cb( $field_args, $field ) {
    $admin_url = str_replace( 'http://', 'https://', get_admin_url() )  . 'admin.php?page=automatorwp_settings&tab=opt-tab-facebook';

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-facebook-redirect-url table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Redirect URL:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <input type="text" class="regular-text" value="<?php echo $admin_url; ?>" readonly>
            <p class="cmb2-metabox-description"><?php echo __( 'Copy this URL and place it the authorized redirect URIs field.', 'automatorwp-pro' ); ?></p>
        </div>
    </div>
    <?php
}

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_facebook_authorize_display_cb( $field_args, $field ) {

    $field_id = $field_args['id'];
    
    $application_id = automatorwp_facebook_get_option( 'application_id', '' );
    $application_secret = automatorwp_facebook_get_option( 'application_secret', '' );
    $auth = get_option( 'automatorwp_facebook_auth' );

    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-facebook-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with Facebook:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <a id="<?php echo $field_id; ?>" class="button button-primary" href="#"><?php echo __( 'Authorize', 'automatorwp-pro' ); ?></a>
            <p class="cmb2-metabox-description"><?php echo __( 'Add your Facebook App application ID and secret fields and click on "Authorize" button to generate access keys for this site.', 'automatorwp-pro' ); ?></p>
            <?php if ( is_array( $auth ) ) : ?>
                <div class="automatorwp-notice-success"><?php echo __( 'Site connected with Facebook successfully.', 'automatorwp-pro' ); ?></div>
                <p class="automatorwp-facebook-access-token"><strong><?php echo __( 'Access token:', 'automatorwp-pro' ); ?></strong> <input type="text" value="<?php echo $auth['access_token']; ?>" readonly></p>
            <?php elseif( ! empty( $application_id ) && ! empty( $application_secret ) ) : ?>
                <div class="automatorwp-notice-error"><?php echo __( 'Site not connected with Facebook.', 'automatorwp-pro' ); ?></div>
            <?php endif; ?>
        </div>
    </div>
    <?php
}

/**
 * Check if authorization process has been completed
 *
 * @since  1.0.0
 */
function automatorwp_facebook_maybe_authorize_complete() {
    
    if( isset( $_GET['code'] )
        && isset( $_GET['page'] ) && $_GET['page'] == 'automatorwp_settings'
        && isset( $_GET['tab'] ) && $_GET['tab'] == 'opt-tab-facebook' ) {

        $application_id = automatorwp_facebook_get_option( 'application_id', '' );
        $application_secret = automatorwp_facebook_get_option( 'application_secret', '' );

        $redirect_url = str_replace( 'http://', 'https://', get_admin_url() ) . 'admin.php?page=automatorwp_settings&tab=opt-tab-facebook';

        $params = array(
            'body'  => array(
                'client_id'     => $application_id,
                'client_secret' => $application_secret,
                'redirect_uri'  => $redirect_url,
                'code'          => $_GET['code']
            )
        );

        $api_version = automatorwp_facebook_api_version();

        $response = wp_remote_get( 'https://graph.facebook.com/' . $api_version . '/oauth/access_token', $params );

        // Bail if can't contact with the server
        if ( is_wp_error( $response ) ) {
            return;
        }

        $body = json_decode( wp_remote_retrieve_body( $response ) );
        
        // Bail on receive an error
        if( isset( $body->error ) ) {
            return;
        }

        $auth = array(
            'access_token'  => $body->access_token,
            'token_type'    => $body->token_type,
        );

        // Update the access and refresh tokens
        update_option( 'automatorwp_facebook_auth', $auth );

        // Redirect to settings again
        wp_redirect( get_admin_url() . 'admin.php?page=automatorwp_settings&tab=opt-tab-facebook' );
        exit;

    }

}
add_action( 'admin_init', 'automatorwp_facebook_maybe_authorize_complete' );